/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSyncNPCCount
implements IMessage {
    private int globalHiredNPCCount;
    private int customMaxHiredNPCs;

    public PacketSyncNPCCount() {
    }

    public PacketSyncNPCCount(int globalHiredNPCCount, int customMaxHiredNPCs) {
        this.globalHiredNPCCount = globalHiredNPCCount;
        this.customMaxHiredNPCs = customMaxHiredNPCs;
    }

    public void fromBytes(ByteBuf buf) {
        this.globalHiredNPCCount = buf.readInt();
        this.customMaxHiredNPCs = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.globalHiredNPCCount);
        buf.writeInt(this.customMaxHiredNPCs);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncNPCCount, IMessage> {
        public IMessage onMessage(final PacketSyncNPCCount message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    LOTRPlayerData playerData;
                    EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null && (playerData = LOTRLevelData.getData((EntityPlayer)player)) != null) {
                        playerData.updateGlobalHiredNPCCount(message.globalHiredNPCCount - playerData.getGlobalHiredNPCCount());
                        playerData.setCustomMaxHiredNPCs(message.customMaxHiredNPCs);
                    }
                }
            });
            return null;
        }
    }
}

